%% IRIS

load fisheriris
t = classregtree(meas,species,...
'names',{'SL' 'SW' 'PL' 'PW'});
sfit = eval(t,meas);
pct = mean(strcmp(sfit,species))


for ntrees=1:50
    %clear all
    load fisheriris
    classes = zeros(1,150);
    classes(strcmp(species,'virginica'))=3;
    classes(strcmp(species,'setosa'))=1;
    classes(strcmp(species,'versicolor'))=2;
    mymodel = classRF_train(meas, classes, ntrees);
    myclass = classRF_predict(meas, mymodel);
    mean(myclass==classes')
end

%% OVARIAN CANCER
load ovariancancer
elem_train = logical(mod(1:216,2));
elem_test = ~elem_train;
t = classregtree(double(obs(elem_train,:)),grp(elem_train));
sfit = eval(t,obs(elem_test,:));
pct = mean(strcmp(sfit,grp(elem_test)))

extra_options.DEBUG_ON = true;
accuracies = zeros(10,1);
for ntrees=1:20
    %clear all
    %load fisheriris
    classes = zeros(1,216);
    classes(strcmp(grp,'Normal'))=2;
    classes(strcmp(grp,'Cancer'))=1;
    mymodel = classRF_train(double(obs(elem_train,:)),classes(elem_train), 16,ntrees,extra_options);
    myclass = classRF_predict(double(obs(elem_test,:)), mymodel);
    accuracies(ntrees) = mean(myclass==classes(elem_test)');
end
plot(accuracies)
